<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cfg="." >
  <xsl:output method="text" indent="yes" encoding="ISO-8859-1"/>
  <!--##############VARIABLES#######################-->
  <xsl:variable name="NEWLINE">
    <xsl:text>&#13;&#10;</xsl:text>
  </xsl:variable>
  <xsl:variable name="INDENT_TAB1">
    <xsl:text>&#09;</xsl:text>
  </xsl:variable>
  <xsl:variable name="INDENT_TAB2">
    <xsl:text>&#09;&#09;</xsl:text>
  </xsl:variable>
  <xsl:variable name="INDENT_TAB3">
    <xsl:text>&#09;&#09;&#09;</xsl:text>
  </xsl:variable>
  <xsl:variable name="INDENT_TAB4">
    <xsl:text>&#09;&#09;&#09;&#09;</xsl:text>
  </xsl:variable>
  <xsl:variable name="INDENT_TAB6">
    <xsl:text>&#09;&#09;&#09;&#09;&#09;&#09;</xsl:text>
  </xsl:variable>
  <xsl:variable name="INDENT_TAB5">
    <xsl:text>&#09;&#09;&#09;&#09;&#09;</xsl:text>
  </xsl:variable>
  <xsl:variable name="INDENT_TAB7">
    <xsl:text>&#09;&#09;&#09;&#09;&#09;&#09;&#09;</xsl:text>
  </xsl:variable>
  <xsl:variable name="SysSettingsFile" select="document('SystemSettings-3-0-0.xml')"/>
  <xsl:template match="*">
    <!--#### MPP Header ####-->
    <xsl:text>##HEADER</xsl:text>
    <xsl:value-of select="$NEWLINE"/>
    <xsl:value-of select="ConfigInfo/CustomerInfo/contractNumber"/>
    <xsl:value-of select="$NEWLINE"/>
    <xsl:value-of select="ConfigInfo/CustomerInfo/name"/>
    <xsl:value-of select="$NEWLINE"/>
    <xsl:value-of select="ConfigInfo/CustomerInfo/address1"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="ConfigInfo/CustomerInfo/address2"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="ConfigInfo/CustomerInfo/address3"/>
    <xsl:value-of select="$NEWLINE"/>
    <xsl:value-of select="ConfigInfo/CustomerInfo/postalCode"/>
    <xsl:text>-</xsl:text>
    <xsl:value-of select="ConfigInfo/CustomerInfo/city"/>
    <xsl:value-of select="$NEWLINE"/>
    <xsl:text>##DATEN</xsl:text>
    <xsl:value-of select="$NEWLINE"/>
    <xsl:text>Meldergruppe</xsl:text>
    <xsl:value-of select="$INDENT_TAB1"/>
    <xsl:text>Meldernummer</xsl:text>
    <xsl:value-of select="$INDENT_TAB1"/>
    <xsl:text>Schaltadresse</xsl:text>
    <xsl:value-of select="$INDENT_TAB1"/>
    <xsl:text>Ring/Stich</xsl:text>
    <xsl:value-of select="$INDENT_TAB1"/>
    <xsl:text>Position</xsl:text>
    <xsl:value-of select="$INDENT_TAB1"/>
    <xsl:text>Melder</xsl:text>
    <xsl:value-of select="$INDENT_TAB1"/>
    <xsl:text>Meldungstyp</xsl:text>
    <xsl:value-of select="$INDENT_TAB1"/>
    <xsl:text>Angesteuerte Schaltadressen</xsl:text>
    <xsl:value-of select="$INDENT_TAB1"/>
    <xsl:text>Meldertyp</xsl:text>
    <xsl:value-of select="$INDENT_TAB1"/>
    <xsl:text>Meldebereich</xsl:text>
    <xsl:value-of select="$INDENT_TAB1"/>
    <xsl:text>Kurzinfo</xsl:text>
    <xsl:value-of select="$INDENT_TAB1"/>
    <xsl:text>Kommentar</xsl:text>
    <xsl:value-of select="$INDENT_TAB1"/>
    <xsl:text>Prüfdatum Q1</xsl:text>
    <xsl:value-of select="$INDENT_TAB1"/>
    <xsl:text>Prüfdatum Q2</xsl:text>
    <xsl:value-of select="$INDENT_TAB1"/>
    <xsl:text>Prüfdatum Q3</xsl:text>
    <xsl:value-of select="$INDENT_TAB1"/>
    <xsl:text>Prüfdatum Q4</xsl:text>
    <xsl:value-of select="$NEWLINE"/>
    <!--####Write out table #### -->
    <xsl:element name="{name()}">
      <xsl:apply-templates select="//AddressEntry">
			</xsl:apply-templates>
    </xsl:element>
  </xsl:template>
  <xsl:template match="//AddressEntry">
    <!--
	- if offset is "Not Transmitted" (==> -1), do not generate this entry! 
	-if SI number is 0, do not add enty
	- if MP_SI_POINT for PAS (Address 60000/1) - do not add entry
	- HVAC Relay Address is contained 2 times - only one address shall be added 
	- Filter SIType == MP_SI_NETWORKNODE
  - Filter group addresses by using MP_PROP_GROUP
  - Filter Onboard-Modules siNumber >= 126
	-->
	<xsl:variable name="PropertyValue">
	<xsl:value-of select="PropertyFlags"/>
	</xsl:variable>
    <xsl:if test="Logical/siNumber != 0 
                        and (Logical/siNumber &lt; 60001) 
                        and Logical/offset != -1 
                        and  (Logical/SIType/enum != 'MP_SI_HVAC' or Physical/device != '2') 
                        and Logical/SIType/enum != 'MP_SI_NETWORKNODE'
                        and contains($PropertyValue,'MP_PROP_GROUP') = false()
                        and (Logical/SIType/enum != 'MP_SI_MODULE' or Logical/siNumber &lt; 126)">
      <xsl:value-of select="Logical/siNumber + Logical/offset"/>
      <xsl:value-of select="$INDENT_TAB1"/>
      <xsl:value-of select="Logical/subNumber"/>
      <xsl:choose>
        <xsl:when test="LSN_Properties">
			<xsl:variable name="MyModule">
			<xsl:value-of select="Physical/module"/>
			</xsl:variable>
			<xsl:variable name="MyLoop">
			<xsl:value-of select="Physical/loop"/>
			</xsl:variable>
		  <xsl:value-of select="$INDENT_TAB2"/>
		  <xsl:value-of select="parent::*/AddressEntry[Logical/SIType/enum='MP_SI_LOOP' and Physical/module=$MyModule and Physical/loop=$MyLoop]/Logical/siNumber"/>
		  <xsl:value-of select="$INDENT_TAB1"/>
		  <xsl:value-of select="Physical/device"/>
		  <xsl:value-of select="$INDENT_TAB1"/>
		  <xsl:value-of select="LSN_Properties/officialName"/>
		  <xsl:value-of select="$INDENT_TAB1"/>
        </xsl:when>
        <xsl:otherwise>
      <xsl:value-of select="$INDENT_TAB5"/>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="FT_Type">
        <xsl:value-of select="FunctionType/enum">
				</xsl:value-of>
      </xsl:variable>
		<xsl:value-of select="$FT_Type"/>
		<xsl:value-of select="$INDENT_TAB2"/>
      <xsl:value-of select="$SysSettingsFile//FunctionType[id=$FT_Type]/VDSId"/>
      <xsl:value-of select="$INDENT_TAB2"/>
      <xsl:variable name="LogicalID">
        <xsl:value-of select="@logicalID">
				</xsl:value-of>
      </xsl:variable>
      <xsl:value-of select="../../Labels/LabelEntry[@logicalID = $LogicalID]/label"/>
      <xsl:value-of select="$NEWLINE"/>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>
